ORCA/M Asm65816 2.1.0

0001 0000                       string asis
0002 0000                       blanks off
0003 0000
0004 0000                       print push
0005 0000                       print off
0006 0000                       include 'common.equ.src'
0007 0000                       include 'driver.equ.src' 
0008 0000                       print pop
0009 0000
0010 0000              * change the following equate to update the version number
0011 0000              VersNum  Equ   $0400                    ;version 4.00
0012 0000
0013 0000              ;================================================================
0014 0000              ;
0015 0000              ;  CFST.EQUATES
0016 0000              ;
0017 0000              ;  Equates file for the Character File System Translator.
0018 0000              ;
0019 0000              ;  Created:     July  8, 1987
0020 0000              ;  Modified:    November 18, 1987
0021 0000              ;  Author:      Andy Stadler
0022 0000              ;
0023 0000              ;================================================================
0024 0000              cfst_id  equ   9                        ; my ID number
0025 0000              read_access equ   $01
0026 0000              write_access equ   $02
0027 0000              read_write_acc equ   $03
0028 0000              max_call equ   $4A                      ; last valid command * 2
0029 0000              max_sys  equ   $4                       ; last valid command * 2
0030 0000
0031 0000              ;================================================================
0032 0000              ;
0033 0000              ;  Dev_Data structure
0034 0000              ;
0035 0000              ;  This specifies the structure of dev_data records.  These are
0036 0000              ;  a linked list of structures, one for each open device.
0037 0000              ;
0038 0000              ;  NOTE:  A device may be multiply opened.  For each open instance
0039 0000              ;         there is an FCR, however there is only one Dev_Data for
0040 0000              ;         each device.
0041 0000              ;
0042 0000              ;================================================================
0043 0000              dd_dev_num equ   0                      ; device number
0044 0000              dd_next_dev equ   dd_dev_num+2          ; VP to next device
0045 0000              dd_open_stat equ   dd_next_dev+4        ; how many times opened.
0046 0000              dd_size  equ   dd_open_stat+2
0047 0000
0048 0000              ;================================================================
0049 0000              ;
0050 0000              ;  cfst's fcr
0051 0000              ;
0052 0000              ;  Because devices opened as files have no associated "volume",
0053 0000              ;  there is no associated VCR.  I need to store the device number
0054 0000              ;  somewhere - normally found in the VCR.  So I add a field to
0055 0000              ;  the end of the fcr.
0056 0000              ;
0057 0000              ;================================================================
0058 0000              fcr_fst_ptr equ   fcr_access+2
0059 0000              fcr_dev_num equ   fcr_fst_ptr           ; device number
0060 0000              my_fcr_length equ   fcr_dev_num+2       ; length of cfst's fcr
0061 0000
0062 0000              ;================================================================
0063 0000              ;
0064 0000              ;  CFST's direct page usage.  Starts at $80, the FST workspace.
0065 0000              ;
0066 0000              ;================================================================
0067 0000              my_ref_num equ   fst_start              ; working reference #
0068 0000              my_dev_num equ   my_ref_num+2           ; working device #
0069 0000              cur_dev  equ   my_dev_num+2             ; vp of current dev_data
0070 0000              cur_dev_ptr equ   cur_dev+4             ; ptr to current dev_data
0071 0000              prev_dev equ   cur_dev_ptr+4            ; vp of previous dev_data
0072 0000              my_fcr   equ   prev_dev+4               ; vp of current fcr
0073 0000              my_fcr_ptr equ   my_fcr+4               ; ptr to current fcr
0074 0000              newl_buf equ   my_fcr_ptr+4             ; vp of fcr's newline buffer
0075 0000              newl_buf_ptr equ   newl_buf+4           ; ptr to fcr's newline buffer
0076 0000              call_class_2 equ   newl_buf_ptr+4       ; incoming call class x 2
0077 0000              my_open_flag equ   call_class_2+2       ; used for open's error recovery
0078 0000              req_access equ   my_open_flag+2         ; requested access bits
0079 0000              dev_access equ   req_access+2           ; device's access bits
0080 0000              grant_access equ   dev_access+2         ; computed access bits
0081 0000              my_req_count equ   grant_access+2       ; request count for read/write
0082 0000              my_pcount equ   my_req_count+4          ; incoming parameter count
0083 0000              my_newl_count equ   my_pcount+2         ; newline list length
0084 0000              my_newl_mask equ   my_newl_count+2      ; newline mask/enable
0085 0000              src_list_ptr equ   my_newl_mask+2       ; source pointer for newline copy
0086 0000              my_trans_count equ   src_list_ptr+4     ; working transfer count
0087 0000
0088 0000              ;-----------------------------------------------
0089 0000              ;
0090 0000              ;   Forward addresses and entries
0091 0000              ;
0092 0000              ;-----------------------------------------------
0093 0000
0094 0000                       ENTRY bad_cmd
0095 0000                       ENTRY block_cmd
0096 0000                       ENTRY do_close
0097 0000                       ENTRY do_flush
0098 0000                       ENTRY do_open
0099 0000                       ENTRY do_read
0100 0000                       ENTRY do_shutdn
0101 0000                       ENTRY do_startup
0102 0000                       ENTRY do_write
0103 0000                       ENTRY error_exit
0104 0000
0105 0000                       eject 
0106 0000              ;================================================================
0107 0000              ;
0108 0000              ;  CFST.MAIN
0109 0000              ;
0110 0000              ;  Contains header, entry points, and exit points of the
0111 0000              ;  character file system translator.
0112 0000              ;
0113 0000              ;  Created:     July 27, 1987
0114 0000              ;  Modified:    January 30, 1988
0115 0000              ;  Author:      Andy Stadler
0116 0000              ;
0117 0000              ;  Copyright (c) 1987-1988, Apple Computer, Inc.
0118 0000              ;  All Rights Reserved.
0119 0000              ;
0120 0000              ;================================================================
0121 0000              ;
0122 0000              ;  This is the Character FST header.
0123 0000              ;
0124 0000              ;  FST Header Definition:
0125 0000              ;
0126 0000              ;  dc  c'FST '                          ; FST identifier
0127 0000              ;  dc  I4'Application_Entry'            ; Entry Point #1
0128 0000              ;  dc  I4'System_Calls'                 ; Entry Point #2
0129 0000              ;  dc  I2'FST_ID'                       ; FST's ID #
0130 0000              ;  dc  I2'$C000'                        ; attribute 110xxxxxxxxxxxxx
0131 0000              ;                                           bit 15 = 1=uppercase paths
0132 0000              ;                                               14 = 0=block/1=character
0133 0000              ;                                               13 = 1=supports formatting
0134 0000              ;  dc  I2'version'
0135 0000              ;  dc  I2'0'                            ; block size
0136 0000              ;  dc  I4'0'                            ; max blocks
0137 0000              ;  dc  I4'0'                            ; min blocks
0138 0000              ;  dc  I4'0'                            ; max file in bytes
0139 0000              ;  dc  I4'0'                            ; reserved field, must be 0
0140 0000              ;  dc  I1'name length'                  ; file system name
0141 0000              ;  dc  c'Character FST'
0142 0000              ;  dc  I2'Comment Length'               ; install time comment
0143 0000              ;  dc  C'Comment goes here'
0144 0000              ;  dc  i2'0'
0145 0000              ;
0146 0000              ; Revision:
0147 0000              ;
0148 0000              ; Mar. 28, 1988 By Rob Turner
0149 0000              ;
0150 0000              ;               Changed the open routine.  The open routine was only
0151 0000              ;               setting up 'drvr_dev_num' if the driver was currently
0152 0000              ;               closed.  This caused 'get_last_dev' to fail.
0153 0000              ;
0154 0000              ;               files changed:
0155 0000              ;                       (1) cfst.open
0156 0000              ;
0157 0000              ; Jun.  28, 1988 by Rob Turner
0158 0000              ;
0159 0000              ;               We now set the block size to zero on entry to the
0160 0000              ;               character fst.
0161 0000              ;
0162 0000              ; Feb. 01, 1989 by Rob Turner
0163 0000              ;
0164 0000              ;               Fixed a bug in Read and Write.  These routines
0165 0000              ;               were not honoring the access that was assigned
0166 0000              ;               at the time of the open call.
0167 0000              ;
0168 0000              ; Mar  27, 1990 by Monte Benaresh
0169 0000              ;
0170 0000              ;               The FLUSH call now supports two types of flush: a "full"
0171 0000              ;               flush, which flushes a file's dirty data blocks and dirty
0172 0000              ;               directory blocks, and a "fast" flush which flushed dirty
0173 0000              ;               data blocks only. Since this concept is only meaningful
0174 0000              ;               for block FST's, the code in this file was simply changed
0175 0000              ;               to allow a P_COUNT of 2.  The FLUSH_TYPE parameter is
0176 0000              ;               ignored entirely.
0177 0000              ;
0178 0000              ;               New FLUSH parameter block:
0179 0000              ;
0180 0000              ;                       |---------------|
0181 0000              ;                       |    P_COUNT    | (word)
0182 0000              ;                       |---------------|
0183 0000              ;                       |    REF_NUM    | (word)
0184 0000              ;                       |---------------|
0185 0000              ;                       |   FLUSH_TYPE  | (word)
0186 0000              ;                       |---------------|
0187 0000              ;
0188 0000              ;               Valid values for FLUSH_TYPE are:
0189 0000              ;                       $0000 = full flush (default)
0190 0000              ;                       $8000 = fast flush
0191 0000              ;
0192 0000              ; August 31, 1991 by Greg Branche
0193 0000              ;
0194 0000              ;               Logic added to speed up writes to the .CONSOLE driver.
0195 0000              ;               At Startup, the FST now scans the device list looking
0196 0000              ;               for the .CONSOLE driver.  When it's found, it stores
0197 0000              ;               the device number for later comparisons, performs an
0198 0000              ;               Add_Trap call to the driver, and then a Reset_Trap to
0199 0000              ;               learn the address of the driver's internal entry point.
0200 0000              ;               During a Write call, the device number is compared to
0201 0000              ;               the .CONSOLE device number and, if they match, the write
0202 0000              ;               call to the driver is dispatched directly to the driver's
0203 0000              ;               internal entry point as opposed to going through the
0204 0000              ;               device dispatcher.
0205 0000              ;
0206 0000              ; December 8, 1991 by Greg Branche
0207 0000              ;
0208 0000              ;               Now that SCM skips the pCount validation if the
0209 0000              ;               callers makes a Read or Write call to the
0210 0000              ;               Character FST, the FST has to do it for itself.
0211 0000              ;               I've changed setup_rw_params to check for a minimum
0212 0000              ;               pCount of 4 and return an invalid_pcount error if
0213 0000              ;               the caller's parameter contains less than that.
0214 0000              ;
0215 0000              ;================================================================
0216 0000              ;Revisions
0217 0000
0218 0000              fst_header PROC 
0219 0000                       Import appl_call,system_call
0220 0000
0221 0000 46 53 54 20           DC B:'FST '
0222 0004 7E 00 02 00           DC L:appl_call
0223 0008 94 00 02 00           DC L:system_call
0224 000C 09 00                 DC W:cfst_id
0225 000E 00 C0                 DC W:$C000
0226 0010 00 04                 DC W:VersNum                   ; version number
0227 0012 00 00                 DC W:0
0228 0014 00 00 00 00           DC L:0
0229 0018 00 00 00 00           DC L:0
0230 001C 00 00 00 00           DC L:0
0231 0020 00 00 00 00           DC L:0
0232 0024 0D                    DC B:13
0233 0025 43 68 61 72           DC B:'Character FST'
0234 0032                       string pascal
0235 0032 1C 43 68 61           DC B:'Character FST         v04.00'
0236 004F 00 00                 DC W:0000
0237 0051 2C 43 68 61           DC B:'Character FST by Andy Stadler and Rob Turner'
0238 007E                       string asis
0239 007E                       ENDP 
0240 007E
0241 007E              ;================================================================
0242 007E              ;
0243 007E              ;  appl_call
0244 007E              ;
0245 007E              ;  This is the entry point for application calls.
0246 007E              ;
0247 007E              ;  Input:       X = Call number * 2
0248 007E              ;               Y = Class number * 2
0249 007E              ;
0250 007E              ;================================================================
0251 007E
0252 007E              appl_call PROC 
0253 007E                       Import cmd_tbl:data
0254 007E
0255 007E 4B                    phk   
0256 007F AB                    plb   
0257 0080 C2 30                 rep   #$30
0258 0082
0259 0082 E0 4B 00              cpx   #max_call+1
0260 0085 B0 05                 bcs   bad_cmd
0261 0087 64 14                 stz   <drvr_blk_size           ; Set blk size to zero for char devices
0262 0089
0263 0089 7C B5 00              jmp   (|cmd_tbl-2,x)
0264 008C
0265 008C              ;================================================================
0266 008C              ;
0267 008C              ;  bad_cmd
0268 008C              ;
0269 008C              ;  An out-of range system call was received.
0270 008C              ;
0271 008C              ;================================================================
0272 008C
0273 008C                       Entry bad_cmd
0274 008C              bad_cmd   
0275 008C
0276 008C A9 01 00              lda   #bad_system_call
0277 008F              ;	bra	error_exit
0278 008F              ; fall into error_exit
0279 008F
0280 008F              ;================================================================
0281 008F              ;
0282 008F              ;  error_exit
0283 008F              ;
0284 008F              ;  Return to the caller with an error condition.
0285 008F              ;
0286 008F              ;  Input:       A = Error Code
0287 008F              ;
0288 008F              ;================================================================
0289 008F
0290 008F                       entry error_exit
0291 008F              error_exit  
0292 008F
0293 008F 38                    sec   
0294 0090 5C 40 FC 01           jml   sys_exit
0295 0094
0296 0094                       ENDP 
0297 0094
0298 0094              ;================================================================
0299 0094              ;
0300 0094              ;  system_call
0301 0094              ;
0302 0094              ;  Entry point for FST system calls.
0303 0094              ;
0304 0094              ;  Input:       X = Call number * 2
0305 0094              ;               Y = Class number * 2
0306 0094              ;
0307 0094              ;================================================================
0308 0094
0309 0094              system_call PROC 
0310 0094                       Import sys_tbl:data
0311 0094
0312 0094 4B                    phk   
0313 0095 AB                    plb   
0314 0096
0315 0096 E0 05 00              cpx   #max_sys+1
0316 0099 90 05                 blt   system_call_1
0317 009B
0318 009B A9 01 00              lda   #bad_system_call
0319 009E 38                    sec   
0320 009F 6B                    rtl   
0321 00A0
0322 00A0              system_call_1  
0323 00A0 64 14                 stz   <drvr_blk_size           ; Set blk size to zero for char devices
0324 00A2 7C FF 00              jmp   (|sys_tbl-2,x)
0325 00A5                       ENDP 
0326 00A5
0327 00A5              ;================================================================
0328 00A5              ;
0329 00A5              ;  block_cmd
0330 00A5              ;
0331 00A5              ;  A block-oriented command was received.  This is a character
0332 00A5              ;  I/O program.
0333 00A5              ;
0334 00A5              ;================================================================
0335 00A5
0336 00A5              block_cmd PROC 
0337 00A5
0338 00A5 A9 58 00              lda   #not_block_dev
0339 00A8 80 E5                 bra   error_exit
0340 00AA                       ENDP 
0341 00AA
0342 00AA              ;================================================================
0343 00AA              ;
0344 00AA              ;  pcount_error
0345 00AA              ;
0346 00AA              ;  A parameter block was received without enough parameters.
0347 00AA              ;
0348 00AA              ;================================================================
0349 00AA
0350 00AA              pcount_error PROC 
0351 00AA
0352 00AA A9 04 00              lda   #invalid_pcount
0353 00AD 80 E0                 bra   error_exit
0354 00AF                       ENDP 
0355 00AF
0356 00AF              ;================================================================
0357 00AF              ;
0358 00AF              ;  ok_exit
0359 00AF              ;
0360 00AF              ;  Return to the caller after a successful operation.
0361 00AF              ;
0362 00AF              ;  OUTPUTS:     A = no_error
0363 00AF              ;               C = clear
0364 00AF              ;
0365 00AF              ;================================================================
0366 00AF
0367 00AF              ok_exit  PROC 
0368 00AF
0369 00AF 18                    clc   
0370 00B0 A9 00 00              lda   #no_error
0371 00B3 5C 40 FC 01           jml   sys_exit
0372 00B7                       ENDP 
0373 00B7
0374 00B7                       eject 
0375 00B7              ;================================================================
0376 00B7              ;
0377 00B7              ;  CFST.DATA
0378 00B7              ;
0379 00B7              ;  Data Tables for Character File System Translator.
0380 00B7              ;
0381 00B7              ;  Created:     July 08, 1987
0382 00B7              ;  Modified:    See modification history
0383 00B7              ;  Author:      Andy Stadler
0384 00B7              ;
0385 00B7              ;  Copyright 1987 Apple Computer, Inc.
0386 00B7              ;  All rights reserved.
0387 00B7              ;
0388 00B7              ;================================================================
0389 00B7              ;
0390 00B7              ;  Modification history:
0391 00B7              ;
0392 00B7              ;  01-Feb-88    ADS     Initial release
0393 00B7              ;  02-Feb-88    ADS     string_buffer added
0394 00B7              ;                       dispatch table cleaned up
0395 00B7              ;
0396 00B7              ;================================================================
0397 00B7
0398 00B7
0399 00B7
0400 00B7              ;================================================================
0401 00B7              ;
0402 00B7              ;  dispatch_tables
0403 00B7              ;
0404 00B7              ;  These are the jump tables used for the various commands.
0405 00B7              ;
0406 00B7              ;================================================================
0407 00B7
0408 00B7              cmd_tbl  Record 
0409 00B7 A5 00                 DC W:block_cmd                 ; $01 Create
0410 00B9 A5 00                 DC W:block_cmd                 ; $02 Destroy
0411 00BB 8C 00                 DC W:bad_cmd                   ; $03 no call here
0412 00BD A5 00                 DC W:block_cmd                 ; $04 Change Path
0413 00BF A5 00                 DC W:block_cmd                 ; $05 Set File Info
0414 00C1 A5 00                 DC W:block_cmd                 ; $06 Get File Info
0415 00C3 8C 00                 DC W:bad_cmd                   ; $07 no call here
0416 00C5 A5 00                 DC W:block_cmd                 ; $08 Volume
0417 00C7 8C 00                 DC W:bad_cmd                   ; $09 Set Prefix
0418 00C9 8C 00                 DC W:bad_cmd                   ; $0A Get Prefix
0419 00CB A5 00                 DC W:block_cmd                 ; $0B Clear Backup Bit
0420 00CD 8C 00                 DC W:bad_cmd                   ; $0C Destroy Purge
0421 00CF 8C 00                 DC W:bad_cmd                   ; $0D Null
0422 00D1 8C 00                 DC W:bad_cmd                   ; $0E Expand Path
0423 00D3 8C 00                 DC W:bad_cmd                   ; $0F Alter Dir
0424 00D5 4C 03                 DC W:do_open                   ; $10 Open
0425 00D7 8C 00                 DC W:bad_cmd                   ; $11 Newline (handled by SCM)
0426 00D9 81 04                 DC W:do_read                   ; $12 Read
0427 00DB 45 05                 DC W:do_write                  ; $13 Write
0428 00DD 9F 05                 DC W:do_close                  ; $14 Close
0429 00DF FB 05                 DC W:do_flush                  ; $15 Flush
0430 00E1 A5 00                 DC W:block_cmd                 ; $16 Set_mark
0431 00E3 A5 00                 DC W:block_cmd                 ; $17 get_mark
0432 00E5 A5 00                 DC W:block_cmd                 ; $18 set_eof
0433 00E7 A5 00                 DC W:block_cmd                 ; $19 get_eof
0434 00E9 8C 00                 DC W:bad_cmd                   ; $1A set_level
0435 00EB 8C 00                 DC W:bad_cmd                   ; $1B get_level
0436 00ED A5 00                 DC W:block_cmd                 ; $1C get_dir_entry
0437 00EF 8C 00                 DC W:bad_cmd                   ; $1D Reserved
0438 00F1 8C 00                 DC W:bad_cmd                   ; $1E Reserved
0439 00F3 8C 00                 DC W:bad_cmd                   ; $1F Reserved
0440 00F5 8C 00                 DC W:bad_cmd                   ; $20 Get_dev_number
0441 00F7 8C 00                 DC W:bad_cmd                   ; $21 get_last_dev
0442 00F9 A5 00                 DC W:block_cmd                 ; $22 read_block
0443 00FB A5 00                 DC W:block_cmd                 ; $23 write_block
0444 00FD A5 00                 DC W:block_cmd                 ; $24 format
0445 00FF A5 00                 DC W:block_cmd                 ; $25 erase_disk
0446 0101                       EndR 
0447 0101
0448 0101              sys_tbl  Record 
0449 0101 58 02                 DC W:do_startup                ; $01 Startup
0450 0103 4A 03                 DC W:do_shutdn                 ; $02 Shutdown
0451 0105                       EndR 
0452 0105
0453 0105                       eject 
0454 0105              ;================================================================
0455 0105              ;
0456 0105              ;  my_data
0457 0105              ;
0458 0105              ;  Private data area for the CFST.
0459 0105              ;
0460 0105              ;================================================================
0461 0105
0462 0105              cfst_data Record 
0463 0105
0464 0105 00 00 00 00  open_devices DC L:0000                  ; 1st vp of a linked list
0465 0109
0466 0109 00 00 00 00  string_buffer DS B:33                   ; for converting strings
0467 012A
0468 012A 00 00        cons_dev_num DS W:1                     ; console device number
0469 012C
0470 012C 00 00 00 00  cons_dib_ptr DS L:1                     ; console DIB pointer
0471 0130
0472 0130                       ENDP 
0473 0130
0474 0130                       eject 
0475 0130              ;================================================================
0476 0130              ;
0477 0130              ;  add_dev
0478 0130              ;
0479 0130              ;  Adds a device to the device list.  Note that there better
0480 0130              ;  not be another occurence of this device, because I make no
0481 0130              ;  attempt to fish out duplicates.
0482 0130              ;
0483 0130              ;  Inputs:      A = Device Number
0484 0130              ;
0485 0130              ;  Outputs:     open_devices = VP of new device
0486 0130              ;               cur_dev      = (same)
0487 0130              ;               cur_dev_ptr  = Ptr to new device
0488 0130              ;               C            = Set if couldn't allocate it
0489 0130              ;
0490 0130              ;  New Device Initialized to:
0491 0130              ;
0492 0130              ;               next_dev     = previous first dev (head insertion)
0493 0130              ;               dev_num      = new device number
0494 0130              ;               open_stat    = 0 (not yet opened)
0495 0130              ;
0496 0130              ;================================================================
0497 0130
0498 0130              add_dev  PROC 
0499 0130                       with cfst_data
0500 0130
0501 0130 48                    pha                            ; remember new dev #
0502 0131 AD 07 01              lda   |open_devices+2          ; preserve link
0503 0134 48                    pha   
0504 0135 AD 05 01              lda   |open_devices
0505 0138 48                    pha   
0506 0139
0507 0139 A9 08 00              lda   #dd_size                 ; get some memory
0508 013C 22 1C FC 01           jsl   alloc_seg
0509 0140 90 07                 bcc   add_device_ok            ; ok
0510 0142
0511 0142 68                    pla                            ; clean up stack
0512 0143 68                    pla   
0513 0144 68                    pla   
0514 0145 A9 54 00              lda   #out_of_mem
0515 0148 60                    rts                            ; error exit
0516 0149
0517 0149              add_device_ok  
0518 0149 86 84                 stx   <cur_dev                 ; save the new vp in 2 places
0519 014B 84 86                 sty   <cur_dev+2
0520 014D 8E 05 01              stx   |open_devices
0521 0150 8C 07 01              sty   |open_devices+2
0522 0153 22 38 FC 01           jsl   deref
0523 0157 86 88                 stx   <cur_dev_ptr
0524 0159 84 8A                 sty   <cur_dev_ptr+2
0525 015B
0526 015B A0 02 00              ldy   #dd_next_dev             ; reconnect chain
0527 015E 68                    pla   
0528 015F 97 88                 sta   [<cur_dev_ptr],y
0529 0161 C8                    iny   
0530 0162 C8                    iny   
0531 0163 68                    pla   
0532 0164 97 88                 sta   [<cur_dev_ptr],y
0533 0166
0534 0166 A0 00 00              ldy   #dd_dev_num              ; store device number
0535 0169 68                    pla   
0536 016A 97 88                 sta   [<cur_dev_ptr],y
0537 016C
0538 016C A0 06 00              ldy   #dd_open_stat            ; store new open status
0539 016F A9 00 00              lda   #0000
0540 0172 97 88                 sta   [<cur_dev_ptr],y
0541 0174
0542 0174 18                    clc                            ; success exit
0543 0175 60                    rts   
0544 0176                       ENDP 
0545 0176
0546 0176                       eject 
0547 0176              ;================================================================
0548 0176              ;
0549 0176              ;  find_dev
0550 0176              ;
0551 0176              ;  Given a device number, see if it is currently open.  We do
0552 0176              ;  this by looking for a Dev_Data record with the device number.
0553 0176              ;
0554 0176              ;  Inputs:      my_dev_num   = Device Number
0555 0176              ;
0556 0176              ;  Outputs:     cur_dev      = vp of the device record
0557 0176              ;               cur_dev_ptr  = pointer to device record
0558 0176              ;               prev_dev     = vp of the previous record (0 if 1st device)
0559 0176              ;               C            = Set if not found, clear if found
0560 0176              ;                              (above fields =0L if not found)
0561 0176              ;================================================================
0562 0176
0563 0176              find_dev PROC 
0564 0176                       with cfst_data
0565 0176
0566 0176 64 8C                 stz   <prev_dev
0567 0178 64 8E                 stz   <prev_dev+2
0568 017A
0569 017A AD 05 01              lda   |open_devices            ; any open?
0570 017D 0D 07 01              ora   |open_devices+2
0571 0180 F0 3E                 beq   none_found
0572 0182
0573 0182 AE 05 01              ldx   |open_devices            ; setup to check 1st
0574 0185 86 84                 stx   <cur_dev
0575 0187 AC 07 01              ldy   |open_devices+2
0576 018A 84 86                 sty   <cur_dev+2
0577 018C 22 38 FC 01           jsl   deref
0578 0190
0579 0190              find_dev_lp  
0580 0190 86 88                 stx   <cur_dev_ptr             ; check device number
0581 0192 84 8A                 sty   <cur_dev_ptr+2
0582 0194 A0 00 00              ldy   #dd_dev_num
0583 0197 B7 88                 lda   [<cur_dev_ptr],y
0584 0199 C5 82                 cmp   <my_dev_num
0585 019B F0 29                 beq   dev_found
0586 019D
0587 019D A5 84                 lda   <cur_dev                 ; move to next open device
0588 019F 85 8C                 sta   <prev_dev
0589 01A1 A5 86                 lda   <cur_dev+2
0590 01A3 85 8E                 sta   <prev_dev+2
0591 01A5
0592 01A5 A0 02 00              ldy   #dd_next_dev
0593 01A8 B7 88                 lda   [<cur_dev_ptr],y
0594 01AA 85 84                 sta   <cur_dev
0595 01AC C8                    iny   
0596 01AD C8                    iny   
0597 01AE B7 88                 lda   [<cur_dev_ptr],y
0598 01B0 85 86                 sta   <cur_dev+2
0599 01B2 05 84                 ora   <cur_dev                 ; end of list?
0600 01B4 F0 0A                 beq   none_found
0601 01B6
0602 01B6 A6 84                 ldx   <cur_dev
0603 01B8 A4 86                 ldy   <cur_dev+2
0604 01BA 22 38 FC 01           jsl   deref
0605 01BE 80 D0                 bra   find_dev_lp
0606 01C0
0607 01C0              none_found  
0608 01C0 64 84                 stz   <cur_dev
0609 01C2 64 86                 stz   <cur_dev+2
0610 01C4 38                    sec   
0611 01C5 60                    rts   
0612 01C6
0613 01C6 18           dev_found clc   
0614 01C7 60                    rts   
0615 01C8                       ENDP 
0616 01C8
0617 01C8                       eject 
0618 01C8              ;================================================================
0619 01C8              ;
0620 01C8              ;  release_dev
0621 01C8              ;
0622 01C8              ;  Removes a closed device from the device chain.  Assumes the
0623 01C8              ;  device was found using find_dev, i.e. cur_dev, cur_dev_ptr,
0624 01C8              ;  and prev_dev are all set up.
0625 01C8              ;
0626 01C8              ;================================================================
0627 01C8
0628 01C8              release_dev PROC 
0629 01C8                       with cfst_data
0630 01C8
0631 01C8 A5 8C                 lda   <prev_dev                ; special case if 1st entry
0632 01CA 05 8E                 ora   <prev_dev+2
0633 01CC D0 11                 bne   normal_remove
0634 01CE
0635 01CE A0 02 00              ldy   #dd_next_dev             ; remove the 1st item in the list
0636 01D1 B7 88                 lda   [<cur_dev_ptr],y         ; by making the 2nd item into
0637 01D3 8D 05 01              sta   |open_devices            ; the 1st item
0638 01D6 C8                    iny   
0639 01D7 C8                    iny   
0640 01D8 B7 88                 lda   [<cur_dev_ptr],y
0641 01DA 8D 07 01              sta   |open_devices+2
0642 01DD 80 22                 bra   dispose_device           ; and dump the memory
0643 01DF
0644 01DF              normal_remove  
0645 01DF A0 02 00              ldy   #dd_next_dev             ; get the link
0646 01E2 B7 88                 lda   [<cur_dev_ptr],y
0647 01E4 48                    pha   
0648 01E5 C8                    iny   
0649 01E6 C8                    iny   
0650 01E7 B7 88                 lda   [<cur_dev_ptr],y
0651 01E9 48                    pha   
0652 01EA
0653 01EA A6 8C                 ldx   <prev_dev                ; and connect it one back
0654 01EC A4 8E                 ldy   <prev_dev+2
0655 01EE 22 38 FC 01           jsl   deref
0656 01F2 86 88                 stx   <cur_dev_ptr
0657 01F4 84 8A                 sty   <cur_dev_ptr+2
0658 01F6
0659 01F6 A0 04 00              ldy   #dd_next_dev+2           ; (restore comes off backwards)
0660 01F9 68                    pla   
0661 01FA 97 88                 sta   [<cur_dev_ptr],y
0662 01FC 88                    dey   
0663 01FD 88                    dey   
0664 01FE 68                    pla   
0665 01FF 97 88                 sta   [<cur_dev_ptr],y
0666 0201
0667 0201              dispose_device  
0668 0201 A6 84                 ldx   <cur_dev                 ; and deallocate the memory
0669 0203 A4 86                 ldy   <cur_dev+2
0670 0205 22 20 FC 01           jsl   release_seg
0671 0209
0672 0209 60                    rts   
0673 020A                       ENDP 
0674 020A
0675 020A                       eject 
0676 020A              ;================================================================
0677 020A              ;
0678 020A              ;  setup_rw_params
0679 020A              ;
0680 020A              ;  Copy the data out of a read or write parameter block and
0681 020A              ;  get the fcr.
0682 020A              ;
0683 020A              ;  INPUTS:      X = Call number x 2
0684 020A              ;               Y = Call Class x 2
0685 020A              ;
0686 020A              ;  OUTPUTS:     my_ref_num              = file reference number
0687 020A              ;               drvr_buf_ptr            = user buffer pointer
0688 020A              ;               my_req_count            = requested transfer count
0689 020A              ;               my_fcr                  = vp of active fcr
0690 020A              ;               my_fcr_ptr              = ptr to active fcr
0691 020A              ;
0692 020A              ;  This call will return to the shell if there is a parameter
0693 020A              ;  count error.
0694 020A              ;
0695 020A              ;================================================================
0696 020A
0697 020A              setup_rw_params PROC 
0698 020A
0699 020A 84 A0                 sty   <call_class_2            ; which class
0700 020C 98                    tya   
0701 020D F0 0F                 beq   read_params              ; 0
0702 020F
0703 020F A7 32                 lda   [<param_blk_ptr]         ; 1- get pcount
0704 0211 C9 04 00              cmp   #$0004                   ; at least minimum pCount?
0705 0214 90 05                 bcc   @bad_pCount              ; no...
0706 0216 C9 06 00              cmp   #$0006                   ; max pcount + 1
0707 0219 90 03                 blt   read_params
0708 021B              @bad_pCount  
0709 021B 82 8C FE              brl   pcount_error             ; no.
0710 021E
0711 021E              read_params  
0712 021E B7 32                 lda   [<param_blk_ptr],y
0713 0220 85 80                 sta   <my_ref_num
0714 0222 C8                    iny   
0715 0223 C8                    iny   
0716 0224 B7 32                 lda   [<param_blk_ptr],y
0717 0226 85 04                 sta   <drvr_buf_ptr
0718 0228 C8                    iny   
0719 0229 C8                    iny   
0720 022A B7 32                 lda   [<param_blk_ptr],y
0721 022C 85 06                 sta   <drvr_buf_ptr+2
0722 022E C8                    iny   
0723 022F C8                    iny   
0724 0230 B7 32                 lda   [<param_blk_ptr],y
0725 0232 85 AA                 sta   <my_req_count
0726 0234 C8                    iny   
0727 0235 C8                    iny   
0728 0236 B7 32                 lda   [<param_blk_ptr],y
0729 0238 85 AC                 sta   <my_req_count+2
0730 023A
0731 023A              ;  Get this guy's fcr
0732 023A
0733 023A              ;================================================================
0734 023A              ;
0735 023A              ;  set_fcr_ptr
0736 023A              ;
0737 023A              ;  On refnum calls, the SCM sets up fcr_ptr with the VP of
0738 023A              ;  the corresponding fcr.  Pull that value and convert it
0739 023A              ;  to a true pointer 'my_fcr_ptr'.
0740 023A              ;
0741 023A              ;================================================================
0742 023A                       Entry set_fcr_ptr
0743 023A              set_fcr_ptr  
0744 023A
0745 023A A6 3A                 ldx   <fcr_ptr
0746 023C A4 3C                 ldy   <fcr_ptr+2
0747 023E 22 38 FC 01           jsl   deref
0748 0242 86 94                 stx   <my_fcr_ptr
0749 0244 84 96                 sty   <my_fcr_ptr+2
0750 0246
0751 0246 60                    rts   
0752 0247
0753 0247                       ENDP 
0754 0247
0755 0247                       eject 
0756 0247              ;================================================================
0757 0247              ;
0758 0247              ;  store_transfer
0759 0247              ;
0760 0247              ;  Compute an offset into the parameter block and save the
0761 0247              ;  transfer count passed in X.  Used for read and write.
0762 0247              ;
0763 0247              ;  Note:  Since the minimum pcount for read/write includes
0764 0247              ;         the transfer_count position, we don't need to
0765 0247              ;         verify before writing into it.
0766 0247              ;
0767 0247              ;  INPUTS:      A,X                     = transfer count lo, hi
0768 0247              ;               call_class_2            = call class x 2
0769 0247              ;               param_block_ptr         = ptr to paramter block
0770 0247              ;
0771 0247              ;  OUTPUTS:     transfer_count field of parameter block contains
0772 0247              ;               the transfer count.
0773 0247              ;
0774 0247              ;================================================================
0775 0247
0776 0247              store_transfer PROC 
0777 0247
0778 0247 48                    pha                            ; store 1/2 of xfer ct
0779 0248
0780 0248 18                    clc                            ; determine xfer ct position
0781 0249 A5 A0                 lda   <call_class_2            ; class 0 - offset 10
0782 024B 69 0A 00              adc   #0010                    ; class 1 - offset 12
0783 024E A8                    tay                            ; offset -> Y
0784 024F
0785 024F 68                    pla                            ; get lo word
0786 0250 97 32                 sta   [<param_blk_ptr],y
0787 0252 C8                    iny   
0788 0253 C8                    iny   
0789 0254 8A                    txa                            ; hi word -> A
0790 0255 97 32                 sta   [<param_blk_ptr],y
0791 0257 60                    rts   
0792 0258
0793 0258                       ENDP 
0794 0258
0795 0258                       eject 
0796 0258              ;================================================================
0797 0258              ;
0798 0258              ;  do_startup
0799 0258              ;
0800 0258              ;  Initialize the FST.
0801 0258              ;
0802 0258              ;  Output:      C = clear               (call can't fail!)
0803 0258              ;
0804 0258              ;================================================================
0805 0258
0806 0258              do_startup PROC 
0807 0258                       with cfst_data
0808 0258              ConsVersNum equ   $3000
0809 0258
0810 0258 9C 05 01              stz   |open_devices            ; no open devices yet
0811 025B 9C 07 01              stz   |open_devices+2
0812 025E
0813 025E              ; Scan the device list looking for the .CONSOLE driver
0814 025E
0815 025E 64 00                 stz   <drvr_dev_num            ; call the dispatcher directly
0816 0260 A9 01 00              lda   #get_dib_ptr             ; get_dib_ptr call
0817 0263 85 02                 sta   <drvr_call_num
0818 0265 64 04                 stz   <dev_id_ref              ; start at device #0 (incremented before use)
0819 0267              @scan_loop  
0820 0267 E6 04                 inc   <dev_id_ref              ; bump the device number
0821 0269 22 00 FC 01           jsl   <dev_dispatcher          ; get the DIB pointer
0822 026D 90 05                 bcc   @check_info
0823 026F              @not_found  
0824 026F 9C 2A 01              stz   cons_dev_num             ;we don't know where the console driver is
0825 0272 18                    clc   
0826 0273 6B                    rtl   
0827 0274
0828 0274              @check_info  
0829 0274 A0 34 00              ldy   #dev_id_num              ; check the device ID first
0830 0277 B7 20                 lda   [<drvr_dib_ptr],y
0831 0279 C9 0A 00              cmp   #$000A
0832 027C D0 E9                 bne   @scan_loop               ; if not console driver, skip to next device
0833 027E
0834 027E A0 08 00              ldy   #dev_char                ; look at the characteristics
0835 0281 B7 20                 lda   [<drvr_dib_ptr],y
0836 0283 29 FF FB              and   #%1111101111111111       ; doesn't matter whether the name is fixed or not (gab)
0837 0286 C9 60 0B              cmp   #$0B60
0838 0289 D0 DC                 bne   @scan_loop               ; sorry I don't know this console
0839 028B A0 2E 00              ldy   #slot_num                ; check the slot number
0840 028E B7 20                 lda   [<drvr_dib_ptr],y
0841 0290 C9 03 80              cmp   #$8003                   ; fake slot 3
0842 0293 D0 D2                 bne   @scan_loop
0843 0295 A0 30 00              ldy   #unit_num
0844 0298 B7 20                 lda   [<drvr_dib_ptr],y
0845 029A 3A                    dec   a
0846 029B D0 CA                 bne   @scan_loop               ; we want unit 1
0847 029D A0 32 00              ldy   #ver_num
0848 02A0 B7 20                 lda   [<drvr_dib_ptr],y        ; we can only use version 3 or greater
0849 02A2 29 F0 FF              and   #$FFF0                   ; don't care about alpha, beta, or whatever
0850 02A5 C9 00 30              cmp   #ConsVersNum
0851 02A8 90 BD                 bcc   @scan_loop
0852 02AA
0853 02AA              ; this particular driver has passed all the tests, so it must be the REAL
0854 02AA              ; .CONSOLE driver.
0855 02AA
0856 02AA A5 04                 lda   <dev_id_ref              ; passed all tests, copy info to
0857 02AC 8D 2A 01              sta   cons_dev_num             ;   private variables
0858 02AF 85 00                 sta   <drvr_dev_num            ; set up for following driver calls
0859 02B1 A5 20                 lda   <drvr_dib_ptr
0860 02B3 8D 2C 01              sta   cons_dib_ptr
0861 02B6 A5 22                 lda   <drvr_dib_ptr+2
0862 02B8 8D 2E 01              sta   cons_dib_ptr+2
0863 02BB
0864 02BB              ; Now that we've found the console driver, make an add_trap call to tie into
0865 02BB              ; the console driver's execution sequence, then a reset_trap to get control during
0866 02BB              ; a driver call to learn the location of the driver's internal entry point.
0867 02BB
0868 02BB              ;
0869 02BB              ;Before we can use the console driver we must open it first
0870 02BB              ;
0871 02BB A9 01 00              lda   #drvr_open
0872 02BE 85 02                 sta   <drvr_call_num
0873 02C0
0874 02C0 22 00 FC 01           jsl   dev_dispatcher
0875 02C4 B0 A9                 bcs   @not_found               ;oops!
0876 02C6
0877 02C6              ;
0878 02C6              ;Issue a reset_trap call to the console driver.  This will nuke anyone's installed handler
0879 02C6              ;
0880 02C6
0881 02C6 64 08                 stz   <drvr_req_cnt            ;zero request count for this call
0882 02C8 64 0A                 stz   <drvr_req_cnt+2
0883 02CA 64 04                 stz   <drvr_clist_ptr          ;no control list for this one
0884 02CC 64 06                 stz   <drvr_clist_ptr+2
0885 02CE
0886 02CE A9 07 80              lda   #$8007                   ;reset trap address
0887 02D1 85 16                 sta   <drvr_ctrl_code
0888 02D3
0889 02D3 A9 06 00              lda   #drvr_control            ;it's a control call
0890 02D6 85 02                 sta   <drvr_call_num
0891 02D8
0892 02D8 22 00 FC 01           jsl   dev_dispatcher           ;call the dispatcher
0893 02DC B0 37                 bcs   @error_close             ;oops!
0894 02DE              ;
0895 02DE              ;Add in my console driver handling routine.
0896 02DE              ;
0897 02DE A9 04 00              lda   #$0004                   ;setup the request count
0898 02E1 85 08                 sta   <drvr_req_cnt
0899 02E3 64 0A                 stz   <drvr_req_cnt+2
0900 02E5
0901 02E5 A9 28 03              lda   #ctrl_list               ;address of control list
0902 02E8 85 04                 sta   <drvr_clist_ptr
0903 02EA A9 02 00              lda   #^ctrl_list
0904 02ED 85 06                 sta   <drvr_clist_ptr+2
0905 02EF
0906 02EF A9 06 80              lda   #$8006                   ;Add_Trap address
0907 02F2 85 16                 sta   <drvr_ctrl_code
0908 02F4
0909 02F4 A9 06 00              lda   #drvr_control            ;it's a control call
0910 02F7 85 02                 sta   <drvr_call_num
0911 02F9
0912 02F9 22 00 FC 01           jsl   dev_dispatcher           ;call the dispatcher
0913 02FD B0 16                 bcs   @error_close             ;oops!
0914 02FF              ;
0915 02FF              ;Reset the handler again.
0916 02FF              ; Note: this call will cause our Trap_Handler to be called, then
0917 02FF              ;       removed. How's that for trickyness?!?
0918 02FF              ;
0919 02FF 64 08                 stz   <drvr_req_cnt            ;zero request count for this call
0920 0301 64 0A                 stz   <drvr_req_cnt+2
0921 0303 64 04                 stz   <drvr_clist_ptr          ;no control list for this one
0922 0305 64 06                 stz   <drvr_clist_ptr+2
0923 0307
0924 0307 A9 07 80              lda   #$8007                   ;reset trap address
0925 030A 85 16                 sta   <drvr_ctrl_code
0926 030C
0927 030C A9 06 00              lda   #drvr_control            ;it's a control call
0928 030F 85 02                 sta   <drvr_call_num
0929 0311
0930 0311 22 00 FC 01           jsl   dev_dispatcher           ;call the dispatcher
0931 0315
0932 0315              ;
0933 0315              ; Now we can close the driver again
0934 0315              ;
0935 0315              @error_close  
0936 0315 08                    php   
0937 0316 48                    pha                            ;save error code if any
0938 0317 A9 04 00              lda   #drvr_close
0939 031A 85 02                 sta   <drvr_call_num
0940 031C 22 00 FC 01           jsl   dev_dispatcher
0941 0320 68                    pla   
0942 0321 28                    plp   
0943 0322 90 03                 bcc   @all_done
0944 0324 82 48 FF              brl   @not_found
0945 0327              @all_done  
0946 0327 6B                    rtl   
0947 0328
0948 0328 2C 03 02 00  ctrl_list DC L:trap_handler
0949 032C
0950 032C              ;====================================================================================================
0951 032C              ;trap_handler:  This routine is called directly by the console driver!
0952 032C              ;
0953 032C              ;Input:         A = call number
0954 032C              ;               X = undefined
0955 032C              ;               Y = undefined
0956 032C              ;               P = nvmxdizc
0957 032C              ;                   ..000...
0958 032C              ;               b = console driver bank.
0959 032C              ;
0960 032C              ;
0961 032C              ;Output:        A = undefined
0962 032C              ;               X = undefined
0963 032C              ;               Y = undefined
0964 032C              ;               P = nvmxdizc
0965 032C              ;                   ..000...
0966 032C              ;               b = console driver bank
0967 032C              ;
0968 032C              ;
0969 032C              ;====================================================================================================
0970 032C                       longa on
0971 032C                       longi on
0972 032C              trap_handler  
0973 032C                       Import Console_Address
0974 032C
0975 032C 08                    php   
0976 032D 48                    pha   
0977 032E              ;
0978 032E              ;Picture of the stack:
0979 032E              ;
0980 032E              ;       --------------
0981 032E              ;         A Register    $0001
0982 032E              ;       --------------
0983 032E              ;         Process       $0003
0984 032E              ;       --------------
0985 032E              ;         Return addr   $0004
0986 032E              ;       --------------
0987 032E              ;
0988 032E 38                    sec   
0989 032F A3 04                 lda   4,s                      	;get the return address
0990 0331 E9 03 00              sbc   #$0003                   	;get address of Vector call routine!
0991 0334 AA                    tax   
0992 0335 A3 06                 lda   6,s
0993 0337 29 FF 00              and   #$00FF
0994 033A E9 00 00              sbc   #$0000
0995 033D              ;
0996 033D              ;Console_Address jsl	$000000	;call console
0997 033D              ;
0998 033D              ;               $22 00 00 00
0999 033D              ;
1000 033D EB                    xba                            ;put bank address in high byte of accum.
1001 033E 8F 89 05 02           sta   >console_address+2
1002 0342 8A                    txa                            ;low 16 bits of console address.
1003 0343 8F 88 05 02           sta   >console_address+1
1004 0347
1005 0347 68                    pla                            ;restore A register and flags
1006 0348 28                    plp   
1007 0349 6B                    rtl                            ;let the call continue please
1008 034A
1009 034A                       ENDP 
1010 034A
1011 034A                       eject 
1012 034A              ;================================================================
1013 034A              ;
1014 034A              ;  do_shutdn
1015 034A              ;
1016 034A              ;  Shut down the FST.
1017 034A              ;
1018 034A              ;  Output:      C = Clear?  gotta check this....
1019 034A              ;
1020 034A              ;================================================================
1021 034A
1022 034A              do_shutdn PROC 
1023 034A
1024 034A 18                    clc   
1025 034B 6B                    rtl   
1026 034C
1027 034C                       ENDP 
1028 034C
1029 034C                       eject 
1030 034C              ;================================================================
1031 034C              ;
1032 034C              ;  do_open
1033 034C              ;
1034 034C              ;  This is the entry point for the open command.
1035 034C              ;
1036 034C              ;  If it's class 0, the device is opened as available,
1037 034C              ;  and a refnum is returned.
1038 034C              ;
1039 034C              ;  If it's class 1, the device is opened per the request
1040 034C              ;  access, a refnum is returned, and if there are enough
1041 034C              ;  params, the access type is returned.  All other fields
1042 034C              ;  are untouched.
1043 034C              ;
1044 034C              ;  INPUTS:      X = Call Number * 2
1045 034C              ;               Y = Class number * 2
1046 034C              ;               dev_num = device number (set up by SCM)
1047 034C              ;
1048 034C              ;================================================================
1049 034C
1050 034C              do_open  PROC 
1051 034C                       with cfst_data
1052 034C
1053 034C 64 A4                 stz   <req_access              ; default=0=open as permitted
1054 034E 64 AE                 stz   <my_pcount               ; disables stores if class 0
1055 0350
1056 0350 84 A0                 sty   <call_class_2            ; which class
1057 0352 98                    tya   
1058 0353 F0 18                 beq   open_1
1059 0355
1060 0355 A7 32                 lda   [<param_blk_ptr]
1061 0357 85 AE                 sta   <my_pcount
1062 0359 C9 10 00              cmp   #$0010                   ; max pcount + 1
1063 035C 90 03                 blt   open_0
1064 035E 82 49 FD              brl   pcount_error
1065 0361
1066 0361              open_0    
1067 0361 C9 03 00              cmp   #0003
1068 0364 90 07                 blt   open_1                   ; <req_access specified?
1069 0366 A0 08 00              ldy   #0008
1070 0369 B7 32                 lda   [<param_blk_ptr],y
1071 036B 85 A4                 sta   <req_access
1072 036D
1073 036D              ;================================================================
1074 036D              ;
1075 036D              ;  Step 1:  Based on the access (a) requested and (b) allowed,
1076 036D              ;           generate an access bits word for this open.
1077 036D              ;
1078 036D              ;           In addition, I check the driver type.  If its a
1079 036D              ;           block device, I must coerce the SCM into more
1080 036D              ;           bouncing....  So I return 'File System Not Supported.'
1081 036D              ;
1082 036D              ;================================================================
1083 036D
1084 036D              open_1    
1085 036D 64 00                 stz   <drvr_dev_num            ; make get_dib_ptr call
1086 036F A9 01 00              lda   #get_dib_ptr
1087 0372 85 02                 sta   <drvr_call_num
1088 0374 A5 36                 lda   <dev_num
1089 0376 85 04                 sta   <drvr_buf_ptr
1090 0378 22 00 FC 01           jsl   dev_dispatcher
1091 037C 90 06                 bcc   got_the_dib
1092 037E
1093 037E A9 46 00              lda   #file_not_found
1094 0381 82 0B FD              brl   error_exit               ; probably bad device number
1095 0384
1096 0384              got_the_dib  
1097 0384 A0 08 00              ldy   #8                       ; address of characteristics
1098 0387 B7 20                 lda   [<drvr_dib_ptr],y
1099 0389 29 80 00              and   #$0080                   ; block dev or char?
1100 038C F0 06                 beq   dib_says_char
1101 038E
1102 038E A9 52 00              lda   #unknown_vol             ; bounce!
1103 0391 82 FB FC              brl   error_exit
1104 0394
1105 0394              dib_says_char  
1106 0394 B7 20                 lda   [<drvr_dib_ptr],y        ; now check access bits
1107 0396 0A                    asl   a                        ; xxxxxxxxxWRxxxxx ->
1108 0397 0A                    asl   a                        ; 00000000000000WR
1109 0398 0A                    asl   a
1110 0399 EB                    xba   
1111 039A 29 03 00              and   #0003
1112 039D 85 A6                 sta   <dev_access
1113 039F
1114 039F A5 A4                 lda   <req_access              ; did they request 'as available'
1115 03A1 F0 11                 beq   as_avail
1116 03A3
1117 03A3 29 FC FF              and   #$FFFC                   ; any other modes requested?
1118 03A6 F0 06                 beq   set_access
1119 03A8
1120 03A8 A9 4E 00              lda   #invalid_access          ; yes, they're not supported!
1121 03AB 82 E1 FC              brl   error_exit
1122 03AE
1123 03AE              set_access  
1124 03AE A5 A4                 lda   <req_access              ; ok, take the requested modes
1125 03B0 25 A6                 and   <dev_access
1126 03B2 80 02                 bra   store_access
1127 03B4
1128 03B4              as_avail  
1129 03B4 A5 A6                 lda   <dev_access              ; take whatever's available
1130 03B6
1131 03B6              store_access  
1132 03B6 85 A8                 sta   <grant_access
1133 03B8 A6 AE                 ldx   <my_pcount               ; response requested?
1134 03BA E0 05 00              cpx   #0005
1135 03BD 90 05                 blt   open_2
1136 03BF A0 0C 00              ldy   #0012                    ; yes, store it
1137 03C2 97 32                 sta   [<param_blk_ptr],y
1138 03C4
1139 03C4              ;================================================================
1140 03C4              ;
1141 03C4              ;  Step 2:  See if we already know this device.  If so, just
1142 03C4              ;           increment its open_stat.  If not, create a new
1143 03C4              ;           dev_data and actually open the device.
1144 03C4              ;
1145 03C4              ;================================================================
1146 03C4
1147 03C4              open_2    
1148 03C4 64 A2                 stz   <my_open_flag
1149 03C6 A5 36                 lda   <dev_num
1150 03C8 85 82                 sta   <my_dev_num
1151 03CA
1152 03CA A5 36                 lda   <dev_num                 ; open the driver
1153 03CC 85 00                 sta   <drvr_dev_num
1154 03CE
1155 03CE 20 76 01              jsr   find_dev                 ; do we already know it?
1156 03D1 90 1B                 bcc   inc_open
1157 03D3
1158 03D3 A9 01 00              lda   #drvr_open
1159 03D6 85 02                 sta   <drvr_call_num
1160 03D8 22 00 FC 01           jsl   dev_dispatcher
1161 03DC 90 03                 bcc   open_ok
1162 03DE 82 AE FC              brl   error_exit
1163 03E1
1164 03E1              open_ok   
1165 03E1 E6 A2                 inc   <my_open_flag            ; 1 = opened this call
1166 03E3 A5 36                 lda   <dev_num                 ; create the new device data
1167 03E5 20 30 01              jsr   add_dev
1168 03E8 90 04                 bcc   inc_open
1169 03EA 48                    pha                            ; (stack futz, see open_punt)
1170 03EB 82 82 00              brl   punt_2                   ; can't add!  close the driver.
1171 03EE
1172 03EE              inc_open                                ; ; flag of # opens
1173 03EE A0 06 00              ldy   #dd_open_stat
1174 03F1 B7 88                 lda   [<cur_dev_ptr],y
1175 03F3 1A                    inc   a
1176 03F4 97 88                 sta   [<cur_dev_ptr],y
1177 03F6
1178 03F6              ;================================================================
1179 03F6              ;
1180 03F6              ;  Step 3:  Create an FCR.  Certain fields will have to be
1181 03F6              ;           filled in.
1182 03F6              ;
1183 03F6              ;================================================================
1184 03F6
1185 03F6 A4 A0                 ldy   <call_class_2            ; class x 2 -> path ptr offset
1186 03F8 C8                    iny   
1187 03F9 C8                    iny   
1188 03FA
1189 03FA B7 32                 lda   [<param_blk_ptr],y
1190 03FC AA                    tax                            ; path ptr -> X,Y
1191 03FD C8                    iny   
1192 03FE C8                    iny   
1193 03FF B7 32                 lda   [<param_blk_ptr],y
1194 0401 A8                    tay   
1195 0402
1196 0402 A5 A0                 lda   <call_class_2            ; class 0 needs conversion
1197 0404 D0 12                 bne   get_the_fcr
1198 0406
1199 0406              ;  convert class 0 string to class 1 string in local buffer
1200 0406
1201 0406 5A                    phy                            ; source ptr
1202 0407 DA                    phx   
1203 0408 F4 02 00              pea   string_buffer>>16        ; dest ptr
1204 040B F4 09 01              pea   string_buffer
1205 040E 22 74 FC 01           jsl   cvt_0to1
1206 0412
1207 0412 A2 09 01              ldx   #<string_buffer
1208 0415 A0 02 00              ldy   #^string_buffer
1209 0418
1210 0418              ;  insert the new (or the original) string into a new fcr
1211 0418
1212 0418              get_the_fcr  
1213 0418 A9 18 00              lda   #my_fcr_length
1214 041B 22 2C FC 01           jsl   alloc_fcr                ; get the fcr memory
1215 041F 90 06                 bcc   fcr_ok
1216 0421
1217 0421 A9 54 00              lda   #out_of_mem
1218 0424 82 3E 00              brl   open_punt 
1219 0427
1220 0427              fcr_ok    
1221 0427 86 90                 stx   <my_fcr                  ; make a real pointer to it
1222 0429 84 92                 sty   <my_fcr+2
1223 042B 22 38 FC 01           jsl   deref
1224 042F 86 94                 stx   <my_fcr_ptr
1225 0431 84 96                 sty   <my_fcr_ptr+2
1226 0433
1227 0433 A5 36                 lda   <dev_num                 ; fill in the device number
1228 0435 A0 16 00              ldy   #fcr_dev_num
1229 0438 97 94                 sta   [<my_fcr_ptr],y
1230 043A
1231 043A A9 09 00              lda   #cfst_id                 ; fill in my ID number
1232 043D A0 06 00              ldy   #fcr_fst_id
1233 0440 97 94                 sta   [<my_fcr_ptr],y
1234 0442
1235 0442 A9 FF FF              lda   #$FFFF                   ; 'no associated volume'
1236 0445 A0 08 00              ldy   #fcr_vol_id
1237 0448 97 94                 sta   [<my_fcr_ptr],y
1238 044A
1239 044A A5 A8                 lda   <grant_access
1240 044C A0 14 00              ldy   #fcr_access
1241 044F 97 94                 sta   [<my_fcr_ptr],y          ; access
1242 0451
1243 0451 A9 00 00              lda   #0000                    ; newline starts out disabled
1244 0454 A0 12 00              ldy   #fcr_mask
1245 0457 97 94                 sta   [<my_fcr_ptr],y
1246 0459
1247 0459 A0 00 00              ldy   #fcr_ref_num             ; return file ref number
1248 045C B7 94                 lda   [<my_fcr_ptr],y
1249 045E A4 A0                 ldy   <call_class_2            ; class + 0 = ref # index
1250 0460 97 32                 sta   [<param_blk_ptr],y
1251 0462
1252 0462 82 4A FC              brl   ok_exit                  ; success!
1253 0465
1254 0465              ;================================================================
1255 0465              ;
1256 0465              ;  open_punt
1257 0465              ;
1258 0465              ;  Some sort of error occurred, probably out of memory.  If
1259 0465              ;  this was the first instance of opening the driver, close
1260 0465              ;  it before returning the error.
1261 0465              ;
1262 0465              ;================================================================
1263 0465
1264 0465              open_punt  
1265 0465 A6 A2                 ldx   <my_open_flag            ; did we just open it?
1266 0467 F0 15                 beq   go_error
1267 0469
1268 0469              ;  this call opened the driver.  Since something along the line
1269 0469              ;  failed, we need to close it again.
1270 0469
1271 0469 48                    pha                            ; remember the error code
1272 046A
1273 046A 20 76 01              jsr   find_dev                 ; seek out the new record
1274 046D 20 C8 01              jsr   release_dev              ; and nuke it
1275 0470
1276 0470              ;  entry point which just closes (from add_dev failure)
1277 0470
1278 0470              punt_2    
1279 0470 A5 36                 lda   <dev_num                 ; and close the driver
1280 0472 85 00                 sta   <drvr_dev_num
1281 0474 A9 04 00              lda   #drvr_close
1282 0477 85 02                 sta   <drvr_call_num
1283 0479 22 00 FC 01           jsl   dev_dispatcher
1284 047D
1285 047D 68                    pla   
1286 047E
1287 047E              go_error  
1288 047E 82 0E FC              brl   error_exit
1289 0481
1290 0481                       ENDP 
1291 0481
1292 0481                       eject 
1293 0481              ;================================================================
1294 0481              ;
1295 0481              ;  do_read
1296 0481              ;
1297 0481              ;  This implements the read call.  Basically its a straight-
1298 0481              ;  through translation from GS/OS to device-driver format.
1299 0481              ;  Newline is implemented at this level, so for optimization,
1300 0481              ;  there are two methods used:  If newline is disabled, the
1301 0481              ;  entire requested block is transferred by the device.  If
1302 0481              ;  newline is enabled, bytes are transferred one at a time
1303 0481              ;  until the newline is matched.
1304 0481              ;
1305 0481              ;  Created:     July 21, 1987
1306 0481              ;  Modified:    November 4, 1987
1307 0481              ;  Author:      Andy Stadler
1308 0481              ;
1309 0481              ;  Copyright (C) 1987 Apple Computer, Inc.
1310 0481              ;  All Rights Reserved.
1311 0481              ;
1312 0481              ;  INPUTS:      X =     Call number x 2
1313 0481              ;               Y =     Call Class x 2
1314 0481              ;               Param_Block containing:
1315 0481              ;                       Reference #
1316 0481              ;                       Buffer Pointer
1317 0481              ;                       Request Count
1318 0481              ;
1319 0481              ;  OUTPUTS:     C = clear if no error, set if error
1320 0481              ;               A = Error Code
1321 0481              ;               Param_Block with response:
1322 0481              ;                       Transfer Count
1323 0481              ;
1324 0481              ;  Possible Errors:
1325 0481              ;               $23     Driver not open
1326 0481              ;               $27     IO Error
1327 0481              ;               $2F     Off-line error
1328 0481              ;               $4E     Access error (not read-enabled)
1329 0481              ;
1330 0481              ;================================================================
1331 0481
1332 0481              do_read  PROC 
1333 0481
1334 0481 20 0A 02              jsr   setup_rw_params          ; get data from param block
1335 0484
1336 0484              ;  setup default data for the device driver
1337 0484
1338 0484 A0 14 00              ldy   #fcr_access              ; lets check the access please
1339 0487 B7 94                 lda   [<my_fcr_ptr],y
1340 0489 29 01 00              and   #read_access             ; see if the caller has read access
1341 048C D0 06                 bne   @access_ok
1342 048E
1343 048E A9 4E 00              lda   #invalid_access
1344 0491 38                    sec   
1345 0492 80 21                 bra   @exit
1346 0494              @access_ok  
1347 0494 A0 16 00              ldy   #fcr_dev_num             ; get the device number
1348 0497 B7 94                 lda   [<my_fcr_ptr],y
1349 0499 85 00                 sta   <drvr_dev_num
1350 049B
1351 049B A9 02 00              lda   #drvr_read
1352 049E 85 02                 sta   <drvr_call_num
1353 04A0
1354 04A0 64 14                 stz   <drvr_blk_size           ; 0 = character mode
1355 04A2
1356 04A2              ;  Split here for newline or raw modes
1357 04A2
1358 04A2 A0 12 00              ldy   #fcr_mask                ; if mask == 0, newline disabled
1359 04A5 B7 94                 lda   [<my_fcr_ptr],y
1360 04A7 D0 1F                 bne   newline_read
1361 04A9
1362 04A9              ;  Execute a raw read.  Read the entire requested
1363 04A9              ;  amount into the user's buffer.
1364 04A9
1365 04A9 A5 AA                 lda   <my_req_count            ; read full amount
1366 04AB 85 08                 sta   <drvr_req_cnt
1367 04AD A5 AC                 lda   <my_req_count+2
1368 04AF 85 0A                 sta   <drvr_req_cnt+2
1369 04B1 22 00 FC 01           jsl   dev_dispatcher
1370 04B5              @exit     
1371 04B5 48                    pha                            ; save error status
1372 04B6 08                    php   
1373 04B7
1374 04B7 A5 0C                 lda   <drvr_tran_cnt
1375 04B9 A6 0E                 ldx   <drvr_tran_cnt+2
1376 04BB 20 47 02              jsr   store_transfer           ; return transfer count
1377 04BE
1378 04BE 28                    plp                            ; get the error status
1379 04BF 68                    pla   
1380 04C0 90 03                 bcc   ok_read_1
1381 04C2
1382 04C2 82 CA FB              brl   error_exit               ; quit with error code
1383 04C5
1384 04C5              ok_read_1  
1385 04C5 82 E7 FB              brl   ok_exit
1386 04C8
1387 04C8              ;  Execute a newline read.  We must read characters from the
1388 04C8              ;  device driver one-at-a-time into the destination buffer.
1389 04C8              ;  Then we compare them with the newline data.  If the newline
1390 04C8              ;  character is found, terminate the read operation.
1391 04C8
1392 04C8              newline_read  
1393 04C8 A0 0C 00              ldy   #fcr_newline             ; get the newline data
1394 04CB B7 94                 lda   [<my_fcr_ptr],y
1395 04CD AA                    tax   
1396 04CE C8                    iny   
1397 04CF C8                    iny   
1398 04D0 B7 94                 lda   [<my_fcr_ptr],y
1399 04D2 A8                    tay   
1400 04D3 22 38 FC 01           jsl   deref                    ; make a pointer
1401 04D7 86 9C                 stx   <newl_buf_ptr
1402 04D9 84 9E                 sty   <newl_buf_ptr+2
1403 04DB
1404 04DB A0 12 00              ldy   #fcr_mask                ; get mask
1405 04DE B7 94                 lda   [my_fcr_ptr],y
1406 04E0 29 FF 00              and   #$00FF                   ; make sure hi byte is 0's!!!!
1407 04E3 85 B2                 sta   <my_newl_mask
1408 04E5
1409 04E5 A0 10 00              ldy   #fcr_newline_len         ; get count
1410 04E8 B7 94                 lda   [my_fcr_ptr],y
1411 04EA 85 B0                 sta   <my_newl_count
1412 04EC
1413 04EC 64 B8                 stz   <my_trans_count
1414 04EE 64 BA                 stz   <my_trans_count+2
1415 04F0 A9 01 00              lda   #0001                    ; read 1 at a time
1416 04F3 85 08                 sta   <drvr_req_cnt
1417 04F5 64 0A                 stz   <drvr_req_cnt+2
1418 04F7
1419 04F7              ;  loop here reading one character at a time
1420 04F7
1421 04F7              read_lp   
1422 04F7 22 00 FC 01           jsl   dev_dispatcher
1423 04FB 90 0E                 bcc   read_ok
1424 04FD
1425 04FD 48                    pha                            ; read error!
1426 04FE 08                    php   
1427 04FF
1428 04FF A5 B8                 lda   <my_trans_count
1429 0501 A6 BA                 ldx   <my_trans_count+2        ; read stopped by error
1430 0503 20 47 02              jsr   store_transfer
1431 0506
1432 0506 28                    plp   
1433 0507 68                    pla   
1434 0508 82 84 FB              brl   error_exit
1435 050B
1436 050B              read_ok   
1437 050B E6 B8                 inc   <my_trans_count          ; are we full yet?
1438 050D D0 02                 bne   read_ok_1
1439 050F E6 B8                 inc   <my_trans_count
1440 0511
1441 0511              read_ok_1  
1442 0511 A5 B8                 lda   <my_trans_count
1443 0513 C5 AA                 cmp   <my_req_count
1444 0515 D0 06                 bne   read_ok_2
1445 0517
1446 0517 A5 B9                 lda   <my_trans_count+1
1447 0519 C5 AB                 cmp   <my_req_count+1
1448 051B F0 1E                 beq   q_read
1449 051D
1450 051D              read_ok_2  
1451 051D A7 04                 lda   [<drvr_buf_ptr]          ; take a look at the character
1452 051F 25 B2                 and   <my_newl_mask            ; (removing bits of next char)
1453 0521 48                    pha   
1454 0522 A4 B0                 ldy   <my_newl_count
1455 0524
1456 0524              newline_lp  
1457 0524 88                    dey   
1458 0525 B7 9C                 lda   [<newl_buf_ptr],y        ; packed byte array
1459 0527 29 FF 00              and   #$00FF
1460 052A C3 01                 cmp   1,s
1461 052C F0 0C                 beq   hit_newline
1462 052E BB                    tyx   
1463 052F D0 F3                 bne   newline_lp
1464 0531
1465 0531 68                    pla                            ; no, not end of line.
1466 0532 E6 04                 inc   <drvr_buf_ptr            ; move to next char position
1467 0534 D0 C1                 bne   read_lp
1468 0536 E6 06                 inc   <drvr_buf_ptr+2
1469 0538 80 BD                 bra   read_lp                  ; and keep reading.
1470 053A
1471 053A              hit_newline  
1472 053A 68                    pla                            ; trash work value
1473 053B
1474 053B              q_read    
1475 053B A5 B8                 lda   <my_trans_count
1476 053D A6 BA                 ldx   <my_trans_count+2
1477 053F 20 47 02              jsr   store_transfer
1478 0542
1479 0542 82 6A FB              brl   ok_exit
1480 0545                       ENDP 
1481 0545
1482 0545                       eject 
1483 0545              ;================================================================
1484 0545              ;
1485 0545              ;  do_write
1486 0545              ;
1487 0545              ;  Handles the write command for the character file system
1488 0545              ;  translator.  Simply reprocesses the command into a device
1489 0545              ;  driver format and lets the device driver do the work.
1490 0545              ;
1491 0545              ;  Created:     July 22, 1987
1492 0545              ;  Modified:    November 4, 1987
1493 0545              ;  Author:      Andy Stadler
1494 0545              ;
1495 0545              ;  INPUTS:      X =     Call number x 2
1496 0545              ;               Y =     Call Class x 2
1497 0545              ;               Param_Block containing:
1498 0545              ;                       Reference #
1499 0545              ;                       Buffer Pointer
1500 0545              ;                       Request Count
1501 0545              ;
1502 0545              ;  OUTPUTS:     C = clear if no error, set if error
1503 0545              ;               A = Error Code
1504 0545              ;               Param_Block with response:
1505 0545              ;                       Transfer Count
1506 0545              ;
1507 0545              ;  Possible Errors:
1508 0545              ;               $23     Driver not open
1509 0545              ;               $27     IO Error
1510 0545              ;               $2B     Write protected
1511 0545              ;               $2F     Off-line error
1512 0545              ;               $4E     Access error (not write-enabled)
1513 0545              ;
1514 0545              ;================================================================
1515 0545
1516 0545              do_write PROC 
1517 0545                       entry Console_Address
1518 0545                       with cfst_data
1519 0545
1520 0545 20 0A 02              jsr   setup_rw_params          ; get info from param block
1521 0548
1522 0548 A0 14 00              ldy   #fcr_access              ; lets check the access please
1523 054B B7 94                 lda   [<my_fcr_ptr],y
1524 054D 29 02 00              and   #write_access            ; see if the caller has write access
1525 0550 D0 06                 bne   @access_ok
1526 0552
1527 0552 A9 4E 00              lda   #invalid_access
1528 0555 38                    sec   
1529 0556 80 34                 bra   exit
1530 0558              @access_ok  
1531 0558 A9 03 00              lda   #drvr_write
1532 055B 85 02                 sta   <drvr_call_num
1533 055D
1534 055D 64 14                 stz   <drvr_blk_size           ; 0 = character mode
1535 055F
1536 055F A5 AA                 lda   <my_req_count            ; write full amount
1537 0561 85 08                 sta   <drvr_req_cnt
1538 0563 A5 AC                 lda   <my_req_count+2
1539 0565 85 0A                 sta   <drvr_req_cnt+2
1540 0567
1541 0567 A0 16 00              ldy   #fcr_dev_num             ; get the device number
1542 056A B7 94                 lda   [<my_fcr_ptr],y
1543 056C 85 00                 sta   <drvr_dev_num
1544 056E CD 2A 01              cmp   cons_dev_num             ; is it the console driver?
1545 0571 F0 06                 beq   @call_console            ; yes, call the driver directly
1546 0573
1547 0573 22 00 FC 01           jsl   dev_dispatcher           ; write the data
1548 0577 80 13                 bra   exit
1549 0579
1550 0579              @call_console  
1551 0579 AD 2C 01              lda   cons_dib_ptr             ; copy the dib pointer to direct page
1552 057C 85 20                 sta   <drvr_dib_ptr
1553 057E AD 2E 01              lda   cons_dib_ptr+2
1554 0581 85 20                 sta   <drvr_dib_ptr
1555 0583 A9 03 00              lda   #drvr_write              ; call # must be in accumulator
1556 0586 8B                    phb                            ; drivers are allowed to modify DBR
1557 0587 22 00 00 00  Console_Address jsl   $000000           ; call console (address is filled in at startup
1558 058B AB                    plb   
1559 058C
1560 058C              exit      
1561 058C 48                    pha   
1562 058D 08                    php                            ; remember the error status
1563 058E
1564 058E A5 0C                 lda   <drvr_tran_cnt
1565 0590 A6 0E                 ldx   <drvr_tran_cnt+2
1566 0592 20 47 02              jsr   store_transfer           ; return transfer count
1567 0595
1568 0595 28                    plp   
1569 0596 68                    pla   
1570 0597 90 03                 bcc   write_ok
1571 0599
1572 0599 82 F3 FA              brl   error_exit               ; exit with error status
1573 059C
1574 059C              write_ok  
1575 059C 82 10 FB              brl   ok_exit
1576 059F                       ENDP 
1577 059F
1578 059F                       eject 
1579 059F              ;================================================================
1580 059F              ;
1581 059F              ;  do_close
1582 059F              ;
1583 059F              ;  Attempt to close the specified refnum.  If the device is
1584 059F              ;  multiply open, simply decrement the open_stat flag in its
1585 059F              ;  dev_data record, and scrap the fcr.  If it's really closing,
1586 059F              ;  issue a drvr_close call.
1587 059F              ;
1588 059F              ;  INPUTS:      X = Call Number * 2
1589 059F              ;               Y = Class number * 2
1590 059F              ;
1591 059F              ;  POSSIBLE ERROR CODES:
1592 059F              ;
1593 059F              ;  $27 drvr_io_error
1594 059F              ;
1595 059F              ;================================================================
1596 059F
1597 059F              do_close PROC 
1598 059F
1599 059F BB                    tyx                            ; test for max pcount
1600 05A0 F0 08                 beq   close_0
1601 05A2 A7 32                 lda   [<param_blk_ptr]
1602 05A4 3A                    dec   a                        ; must = 1
1603 05A5 F0 03                 beq   close_0
1604 05A7 82 00 FB              brl   pcount_error
1605 05AA
1606 05AA              close_0   
1607 05AA 20 3A 02              jsr   set_fcr_ptr
1608 05AD
1609 05AD A7 94                 lda   [<my_fcr_ptr]            ; ref # is 1st entry
1610 05AF 85 80                 sta   <my_ref_num
1611 05B1
1612 05B1 A0 16 00              ldy   #fcr_dev_num             ;get device # from fcr
1613 05B4 B7 94                 lda   [<my_fcr_ptr],y
1614 05B6 85 82                 sta   <my_dev_num
1615 05B8
1616 05B8 A0 12 00              ldy   #fcr_mask                ; if newline data, release it
1617 05BB B7 94                 lda   [<my_fcr_ptr],y
1618 05BD F0 0F                 beq   close_1
1619 05BF
1620 05BF A0 0C 00              ldy   #fcr_newline             ; kill the newline buffer
1621 05C2 B7 94                 lda   [<my_fcr_ptr],y
1622 05C4 AA                    tax   
1623 05C5 C8                    iny   
1624 05C6 C8                    iny   
1625 05C7 B7 94                 lda   [<my_fcr_ptr],y
1626 05C9 A8                    tay   
1627 05CA 22 20 FC 01           jsl   release_seg
1628 05CE
1629 05CE              close_1   
1630 05CE A5 80                 lda   <my_ref_num              ; kill the fcr
1631 05D0 22 30 FC 01           jsl   release_fcr
1632 05D4
1633 05D4 20 76 01              jsr   find_dev
1634 05D7 A0 06 00              ldy   #dd_open_stat            ;how many opens?
1635 05DA B7 88                 lda   [<cur_dev_ptr],y
1636 05DC 3A                    dec   a
1637 05DD 97 88                 sta   [<cur_dev_ptr],y         ;if other opens,
1638 05DF D0 17                 bne   sk_close                 ;don't close the device
1639 05E1
1640 05E1              ;  This is the last close for this device, remove its
1641 05E1              ;  device info record and issue a close call.
1642 05E1
1643 05E1 A5 80                 lda   <my_ref_num
1644 05E3 20 C8 01              jsr   release_dev              ; remove my device record
1645 05E6
1646 05E6 A5 82                 lda   <my_dev_num              ;close the device
1647 05E8 85 00                 sta   <drvr_dev_num
1648 05EA A9 04 00              lda   #drvr_close
1649 05ED 85 02                 sta   <drvr_call_num
1650 05EF 22 00 FC 01           jsl   dev_dispatcher
1651 05F3 90 03                 bcc   sk_close
1652 05F5
1653 05F5 82 97 FA              brl   error_exit
1654 05F8
1655 05F8              sk_close  
1656 05F8 82 B4 FA              brl   ok_exit                  ; all done!
1657 05FB                       ENDP 
1658 05FB
1659 05FB                       eject 
1660 05FB              ;================================================================
1661 05FB              ;
1662 05FB              ;  do_flush
1663 05FB              ;
1664 05FB              ;  Sends the flush command to the device driver, if that device
1665 05FB              ;  is open.
1666 05FB              ;
1667 05FB              ;  Inputs:      X = Call number x 2
1668 05FB              ;               Y = Class number x 2
1669 05FB              ;
1670 05FB              ;  Outputs:     A = error code
1671 05FB              ;               C = clear if ok, set if error
1672 05FB              ;
1673 05FB              ;  Error Codes:
1674 05FB              ;
1675 05FB              ;  $27          not open (someone else closed the device)
1676 05FB              ;  $2F          off line
1677 05FB              ;
1678 05FB              ;================================================================
1679 05FB
1680 05FB              do_flush PROC 
1681 05FB
1682 05FB 98                    tya                            ; check class
1683 05FC F0 0B                 beq   params_ok
1684 05FE
1685 05FE A7 32                 lda   [<param_blk_ptr]
1686 0600 3A                    dec   a                        ; pcount must = 1 or 2
1687 0601 F0 06                 beq   params_ok
1688 0603 3A                    dec   a                        ; pcount of 2 now allowed 3/27/90
1689 0604 F0 03                 beq   params_ok                ; by Monte Benaresh
1690 0606 82 A1 FA              brl   pcount_error
1691 0609
1692 0609              params_ok  
1693 0609 B7 32                 lda   [<param_blk_ptr],y
1694 060B 85 80                 sta   <my_ref_num
1695 060D
1696 060D 20 3A 02              jsr   set_fcr_ptr
1697 0610
1698 0610 A0 16 00              ldy   #fcr_dev_num             ; get device number
1699 0613 B7 94                 lda   [<my_fcr_ptr],y
1700 0615 85 00                 sta   <drvr_dev_num
1701 0617
1702 0617 A9 07 00              lda   #drvr_flush              ; send command to driver
1703 061A 85 02                 sta   <drvr_call_num
1704 061C 22 00 FC 01           jsl   dev_dispatcher
1705 0620 90 03                 bcc   flush_ok
1706 0622
1707 0622 82 6A FA              brl   error_exit               ; send the error through
1708 0625
1709 0625              flush_ok  
1710 0625 82 87 FA              brl   ok_exit
1711 0628                       ENDP 
1712 0628                       END   
